# Supplementary Materials
## White Paper #1: Scalar Field Framework and Scalar Time Theory (SFT/STT)

**Author:** Armando Zaragoza  
**Affiliation:** USTE Technologies, Simi Valley, California, USA  
**Email:** armando@uste-technologies.com  
**ORCID:** 0009-0007-3542-0979  
**Date:** November 25, 2025  
**License:** CC-BY 4.0  

---

## Overview

This package contains Python scripts that numerically validate the mathematical proofs presented in the whitepaper. These scripts are provided for reproducibility and independent verification.

---

## Contents

### 01_scalar_time_simulation.py
Validates **Section 3.1: Singularity Resolution**. Demonstrates that scalar time T_s remains finite as coordinate time t → 0, resolving the Big Bang singularity without extra dimensions.

**Key Result:** T_s ∝ t^(3/4) remains finite as t → 0.

### 02_vacuum_stability.py
Validates **Section 3.2: Vacuum Stability**. Confirms that the symmetry-broken vacuum at Φ = v is a stable minimum of the Mexican hat potential.

**Key Result:** d²V/dΦ² = 2μ² > 0 at Φ = v (stable minimum).

### 03_resonance_detector_analysis.py
Analysis protocol for **Section 4.1: Scalar Field Resonance Detector**. This script is for use when experimental data becomes available.

**Note:** The experiment has not yet been conducted. This script includes a simulated data generator for testing the analysis pipeline.

**Theoretical Prediction:** Resonance at ~47 kHz with ~1.8× amplification.

---

## Requirements

```
Python >= 3.8
numpy >= 1.20
scipy >= 1.7
pandas >= 1.3
```

## Installation

```bash
pip install numpy scipy pandas
```

## Usage

Run each script directly:

```bash
python 01_scalar_time_simulation.py
python 02_vacuum_stability.py
python 03_resonance_detector_analysis.py
```

---

## Experimental Status

All materials and equipment for the Scalar Field Resonance Detector have been acquired. Laboratory setup is in progress. Experimental results will be published in a follow-up paper upon completion.

---

## Citation

If you use these materials, please cite:

> Zaragoza, A. (2025). Scalar Field Framework and Scalar Time Theory (SFT/STT): A Unified Approach to Emergent Spacetime and Quantum Gravity. White Paper #1, USTE Technologies.

---

## Contact

For questions or collaboration inquiries:
- Email: armando@uste-technologies.com
- ORCID: https://orcid.org/0009-0007-3542-0979
